// ShowInfoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ShowInfoDlg.h"
#include "afxdialogex.h"
#include "ScfPlayerDlg.h"

// CShowInfoDlg dialog

VOID SC_DEBUG( CHAR * pszStr, ... )
{
	char szData[ MAX_PATH ] = "[SCF.PLAYER] ";

	va_list args;

	va_start( args, pszStr );

	_vsnprintf( szData + 13, sizeof( szData ) - 1, pszStr, args );

	va_end( args );

    strcat( szData, "\n" );

	OutputDebugString( szData );
}

IMPLEMENT_DYNAMIC(CShowInfoDlg, CDialogEx)

CShowInfoDlg::CShowInfoDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CShowInfoDlg::IDD, pParent)
{

}

CShowInfoDlg::~CShowInfoDlg()
{
}

void CShowInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);	
	DDX_Control(pDX, IDC_MONTHCALENDAR, m_ctlMonthCalendar);
	DDX_Control(pDX, IDC_SCFPLAYER_ACTIVEXCTRL, m_ctrlScfPlayer);
}


BEGIN_MESSAGE_MAP(CShowInfoDlg, CDialogEx)
	//{{AFX_MSG_MAP(CShowInfoDlg)
	ON_WM_DESTROY()
	ON_WM_CLOSE()	
	ON_NOTIFY(MCN_SELCHANGE, IDC_MONTHCALENDAR, &CShowInfoDlg::OnMcnSelchangeMonthcalendar)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BTN_ENUM, &CShowInfoDlg::OnBnClickedBtnEnum)
END_MESSAGE_MAP()

// CShowInfoDlg message handlers

BOOL CShowInfoDlg::OnInitDialog() 
{
	CDialogEx::OnInitDialog();		

	m_ctrlScfPlayer.SetWinWidthHeight( 1270, 400 );

	m_ctrlScfPlayer.SetBGColor( RGB(  35, 35, 35 ) );

	m_ctrlScfPlayer.SetTextColor( RGB( 255, 255, 255 ) );

	m_ctrlScfPlayer.SetHorizontalGridLinetColor( RGB( 0, 0, 0 ) );

	m_ctrlScfPlayer.SetVerticalGridLinetColor( RGB( 49, 49, 49 ) );

	m_ctlMonthCalendar.SetColor( MCSC_MONTHBK, ::GetSysColor(CTLCOLOR_DLG));

	m_ctlMonthCalendar.SetColor( MCSC_BACKGROUND , ::GetSysColor(CTLCOLOR_DLG));		

	// CLEAN UP DATE STATE
	//
	SYSTEMTIME timeFrom, timeUntil;

	int nCount = m_ctlMonthCalendar.GetMonthRange(&timeFrom, &timeUntil, GMR_DAYSTATE);   	

	LPMONTHDAYSTATE pDayState;

	pDayState = new MONTHDAYSTATE[nCount];

	memset(pDayState, 0, sizeof(MONTHDAYSTATE) * nCount);
	
	m_ctlMonthCalendar.SetDayState(nCount, pDayState);

	delete [] pDayState;

	ShowRecordsDay();

	return TRUE;
}

void CShowInfoDlg::OnDestroy() 
{
	CDialogEx::OnDestroy();
	
	// TODO: Add your message handler code here	
}

void CShowInfoDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default	

	CScfPlayerDlg * pParent = (CScfPlayerDlg *)(GetParent());

	pParent->OnClose();

	CDialogEx::OnClose();
}

void CShowInfoDlg::OnMcnSelchangeMonthcalendar(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMSELCHANGE pSelChange = reinterpret_cast<LPNMSELCHANGE>(pNMHDR);

	// TODO: Add your control notification handler code here

	ShowRecordsDay();

	*pResult = 0;
}

VOID CShowInfoDlg::ShowRecordsDay()
{	
	int nCount = 0;

	BOOL bHasRecords[ 31 ] = {0};

	ULONG nDays = 31;

	SYSTEMTIME timeFrom, timeUntil, timeStartSearch, timeStopSearch;

	nCount = m_ctlMonthCalendar.GetMonthRange(&timeFrom, &timeUntil, GMR_DAYSTATE);

	timeStartSearch.wYear  = timeFrom.wYear;

	if ( timeFrom.wMonth == 12 )
	{
		timeStartSearch.wMonth = 1;
		timeStartSearch.wYear = timeFrom.wYear + 1;
	}
	else
	{
		timeStartSearch.wMonth = timeFrom.wMonth + 1;
	}

	timeStartSearch.wDay			= 1;
	timeStartSearch.wHour			= 0;
	timeStartSearch.wMinute			= 0;
	timeStartSearch.wSecond			= 0;
	timeStartSearch.wMilliseconds	= 0;

	timeStopSearch.wYear			= timeStartSearch.wYear;
	timeStopSearch.wMonth			= timeStartSearch.wMonth;
	timeStopSearch.wDay				= timeStartSearch.wDay;
	timeStopSearch.wHour			= 23;
	timeStopSearch.wMinute			= 59;
	timeStopSearch.wSecond			= 59;
	timeStopSearch.wMilliseconds	= 999;

	ULONGLONG nStartSearchTime = 0, nStopSearchTime = 0;

	SystemTimeToFileTime(&timeStartSearch, (FILETIME *)&nStartSearchTime);

	SystemTimeToFileTime(&timeStopSearch, (FILETIME *)&nStopSearchTime);

	double dStartSearchTime = 0.0, dStopSearchTime = 0.0;	

	QRESULT returns = QCAP_RS_SUCCESSFUL;	

	ULONG nVideoEncoderFormat = 0;

	ULONG nAudioEncoderFormat = 0;

	ULONG nVideoWidth = 0, nVideoHeight = 0;	
	
	double dVideoFrameRate = 0.0;
	
	ULONG nAudioChannels = 0;
	
	ULONG nAudioBitsPerSample = 0;
	
	ULONG nAudioSampleFrequency = 0;

	double dFileStartTime = 0.0;
	
	double dFileStopTime = 0.0;

	double dVideoStartTime = 0.0;

	double dVideoStopTime = 0.0;

	double dTotalDurationTimes = 0.0;

	ULONG nTotalVideoFrames = 0;

	ULONG nTotalAudioFrames = 0;	

	ULONG nTotalMedatadaFrames = 0;	

	for ( ULONG i = 1 ; i <= nDays ; i++ )
	{
		returns = QCAP_RS_SUCCESSFUL;

		timeStartSearch.wDay = (WORD)i;

		timeStopSearch.wDay = (WORD)i;

		SystemTimeToFileTime(&timeStartSearch, (FILETIME *)&nStartSearchTime);

		SystemTimeToFileTime(&timeStopSearch, (FILETIME *)&nStopSearchTime);

		dStartSearchTime = (double)(nStartSearchTime / 10000000);

		dStopSearchTime = (double)(nStopSearchTime / 10000000);

		BOOL bFindData = FALSE;

		while( returns == QCAP_RS_SUCCESSFUL )
		{
			for ( ULONG j = 0 ; j < DEFAULT_MAX_CHANNEL_NUM ; j++ )
			{
				returns = QCAP_RS_ERROR_GENERAL;

				returns = QCAP_SCF_FILE_ENUMERATION( j, dStartSearchTime, dStopSearchTime, NULL, NULL, &dFileStartTime, &dFileStopTime, &dVideoStartTime, &dVideoStopTime, NULL, NULL, 
		
													&nVideoEncoderFormat, &nVideoWidth, &nVideoHeight, &dVideoFrameRate, 
												
													&nAudioEncoderFormat, &nAudioChannels, &nAudioBitsPerSample, &nAudioSampleFrequency, 
		
 													&dTotalDurationTimes, &nTotalVideoFrames, &nTotalAudioFrames, &nTotalMedatadaFrames, TRUE );		

				if ( returns != QCAP_RS_SUCCESSFUL ) { break; }

				bFindData = TRUE;
			}
		}

		if ( bFindData )
		{
			bHasRecords[ i - 1 ] = TRUE;
		}		
	}
	
	LPMONTHDAYSTATE pDayState;

	pDayState = new MONTHDAYSTATE[ nCount ];

	memset(pDayState, 0, sizeof(MONTHDAYSTATE) * nCount);

	int nIndex = 1;		

	// SET THE DAYs OF THE MONTH
	//
	for ( ULONG i = 0 ; i < nDays ; i++ )
	{
		if ( bHasRecords[ i ] )
		{
			pDayState[ nIndex ] |= 1 << i;
		}
	}
	
	// SET STATE AND CLEAN UP
	//
	m_ctlMonthCalendar.SetDayState(nCount, pDayState);

	delete [] pDayState;	
}

void CShowInfoDlg::OnBnClickedBtnEnum()
{
	// TODO: Add your control notification handler code here

	CScfPlayerDlg * pParent = (CScfPlayerDlg *)(GetParent());	 

	HWND hWnd1 = pParent->m_oVideoWnd[ 0 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin1(  (unsigned long) hWnd1 );

	HWND hWnd2 = pParent->m_oVideoWnd[ 1 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin2(  (unsigned long) hWnd2 );

	HWND hWnd3 = pParent->m_oVideoWnd[ 2 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin3(  (unsigned long) hWnd3 );

	HWND hWnd4 = pParent->m_oVideoWnd[ 3 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin4(  (unsigned long) hWnd4 );

	HWND hWnd5 = pParent->m_oVideoWnd[ 4 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin5(  (unsigned long) hWnd5 );

	HWND hWnd6 = pParent->m_oVideoWnd[ 5 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin6(  (unsigned long) hWnd6 );

	HWND hWnd7 = pParent->m_oVideoWnd[ 6 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin7(  (unsigned long) hWnd7 );

	HWND hWnd8 = pParent->m_oVideoWnd[ 7 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin8(  (unsigned long) hWnd8 );

	HWND hWnd9 = pParent->m_oVideoWnd[ 8 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin9(  (unsigned long) hWnd9 );

	HWND hWnd10 = pParent->m_oVideoWnd[ 9 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin10(  (unsigned long) hWnd10 );

	HWND hWnd11 = pParent->m_oVideoWnd[ 10 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin11(  (unsigned long) hWnd11 );

	HWND hWnd12 = pParent->m_oVideoWnd[ 11 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin12(  (unsigned long) hWnd12 );

	HWND hWnd13 = pParent->m_oVideoWnd[ 12 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin13(  (unsigned long) hWnd13 );

	HWND hWnd14 = pParent->m_oVideoWnd[ 13 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin14(  (unsigned long) hWnd14 );

	HWND hWnd15 = pParent->m_oVideoWnd[ 14 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin15(  (unsigned long) hWnd15 );

	HWND hWnd16 = pParent->m_oVideoWnd[ 15 ].GetSafeHwnd();	m_ctrlScfPlayer.SetChWin16(  (unsigned long) hWnd16 );

	SYSTEMTIME timeSelectedDay;

	m_ctlMonthCalendar.GetCurSel( &timeSelectedDay );

	timeSelectedDay.wHour = timeSelectedDay.wMinute = timeSelectedDay.wSecond = timeSelectedDay.wMilliseconds = 0;

	CTime sysSelectedTime( timeSelectedDay );

	m_ctrlScfPlayer.EnumData( sysSelectedTime.GetYear(), sysSelectedTime.GetMonth(), sysSelectedTime.GetDay() );
}

